# print 1. years 1901 to 2099 and
#       2. Search character for grep, 'Y'
#       3.  Starting day of week -- 0 to 6 for Sunday to Saturday
#       4.  1 if leap year else 0
#       5.  Starting day, January 1 relative to September 1, 1993
#               Example, January 1, 2000 == September 2314, 1993
#  Example records:
#  2000 Y 6 1 2314
#  2001 Y 1 0 2680
#  2002 Y 2 0 3045
#  2003 Y 3 0 3410
#  2004 Y 4 1 3775
#  2005 Y 6 0 4141
#  2006 Y 0 0 4506
#  ...

BEGIN {
Year = 1901
DOW = 2
Day = -33845
while ( Year <= 2099 ) {
     Leap = ( ( Year % 4 ) == 0 ) ? 1 : 0
     print Year, "Y", DOW, Leap, Day
     DOW = ( DOW + 1 + Leap ) % 7
     Day = Day + 365 + Leap
     Year++
   }
}
