# print "Usenet" calendar for year:
#  Given:  list of selected years, 1901 to 2099
#    in the format  year Y dow leap start
# where year  == 1901 to 2099
#       Y     == literal "Y" for grep to distinguish years from start values
#       dow   == starting day of week for the year, 0 to 6
#       leap  == leap-year flag, 1 (yes) or 0 (no)
#       start == starting date in September 1993  -- eg. year 2000
#                has  the record: 2000 6 1 2314
#                to show year 2000 starts on Saturday, IS a leap year,
#                and January 1, 2000 is equivalent to September 2314, 1993.
#                Years before 1994 have negative values to flag use of
#                normal dates.

BEGIN { 
# initialize month lengths:
    Month[1] = 31        
    Month[2] = 28   # subject to change
    Month[3] = 31
    Month[4] = 30
    Month[5] = 31
    Month[6] = 30
    Month[7] = 31
    Month[8] = 31
    Month[9] = 30
    Month[10] = 31
    Month[11] = 30
    Month[12] = 31
    MonthName[1] =  " January "
    MonthName[2] =  "February "
    MonthName[3] =  "  March  "
    MonthName[4] =  "  April  "
    MonthName[5] =  "   May   "
    MonthName[6] =  "  June   "
    MonthName[7] =  "  July   "
    MonthName[8] =  " August  "
    MonthName[9] =  "September"
    MonthName[10] = " October "
    MonthName[11] = "November "
    MonthName[12] = "December "

  }

  {
    Year = $1
    CurrentDOW = $3
    Leap = $4
    CurrentDay = $5
    Month[2] = 28 + Leap
    printf("                     ")
    printf("----- Usenet Year %4d Calendar -----\n\n", Year)
    for ( CurrentMonth = 1; CurrentMonth <= 12; CurrentMonth++ ) {
        if ( ( CurrentMonth == 5 ) || ( CurrentMonth == 9 ) )
             printf("\f")
        MonthDay = 1
            printf("                             ")
        if ( CurrentDay > 0 )
            printf("1993  September  1993\n\n")
        else
            printf("%d  %s  %d\n\n", Year, MonthName[CurrentMonth], Year)
        printf("              Sun     Mon     Tue     Wed")
        printf("     Thu     Fri     Sat\n\n")
        NextMonthStart = CurrentDay + Month[CurrentMonth]
        while ( CurrentDay < NextMonthStart ) {
            # print one week
            printf("          ")
            WkDOW = 0
            while ( WkDOW < CurrentDOW ) {
                printf("        ")
                WkDOW++
             }
            while ( ( CurrentDOW < 7 ) && ( CurrentDay < NextMonthStart ) ) {
                printf("%8d", ( CurrentDay > 0 ) ? CurrentDay : MonthDay )
                CurrentDOW++
                CurrentDay++
                MonthDay++
             }                                      
             printf("\n")
             CurrentDOW = CurrentDOW % 7
         }
         printf("\n")
         CurrentDay = NextMonthStart
      }
   printf("\f")
  }
